/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles.lux;

import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import entities.creatures.PlayerCreatureEntity;
import entities.creatures.enemies.LuxEntity;
import entities.missiles.MissileEntity;
import java.util.ArrayList;
import util.Config;
import util.ResourceManager;

public final class LuxAbilityQEntity
extends MissileEntity {
    private ArrayList<PlayerCreatureEntity> entities = new ArrayList();

    public LuxAbilityQEntity(LuxEntity parent, GameState game, int x, int y) {
        super(parent, game, "missiles/lux/abilityQ", x, y);
        this.moveSpeed = Config.get(Config.luxAbilityQProjectileSpeed);
        this.dx = 0.0;
        this.dy = this.moveSpeed;
    }

    @Override
    protected void calculateHitbox() {
        this.hitbox.setBounds((int)this.x + 10, (int)this.y + 80, this.getW() - 19, this.getH() - 80);
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof PlayerCreatureEntity && !this.entities.contains(other)) {
            this.entities.add((PlayerCreatureEntity)other);
            if (((CreatureEntity)other).hasEffectType("spellshield")) {
                ((CreatureEntity)other).removeEffectByType("spellshield");
            } else {
                ResourceManager.get().playSound("lux_abilityQ_hit");
                ((CreatureEntity)other).damage(this, Config.get(Config.luxAbilityQDamage));
                ((CreatureEntity)other).stun(Config.get(Config.luxAbilityQStunDuration));
                ((CreatureEntity)other).addEffect("passiveLux", this.game.getTime() + (long)Config.get(Config.luxPassiveDuration));
            }
            if (this.entities.size() >= 2) {
                this.game.removeEntity(this);
            }
        }
    }
}

